IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Centro_Costos_Saldos_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [CPJ_Centro_Costos_Saldos_Generar]
END
GO


CREATE PROCEDURE [dbo].[CPJ_Centro_Costos_Saldos_Generar] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Variables Recibidas por Parametros*/
DECLARE	@pId_Usuario			INT
DECLARE	@pFlagUsarTrans			TINYINT
DECLARE	@pModoDebug				TINYINT

DECLARE	@pId_Centro_Costo		VARCHAR(10)
DECLARE	@pId_Unid_Negocio		CHAR(10)
DECLARE	@pFecha					DATETIME

SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pId_Centro_Costo	        = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Centro_Costo')), '')
SET @pId_Unid_Negocio	        = ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')), '')
SET @pFecha						= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),GETDATE())
/*FIN Variables Recibidas por Parametros*/

/*Variables Locales*/
DECLARE @Id_Centro_Costo_Saldo_Existente					INT
DECLARE @Id_Centro_Costo_Saldo_Existente_Periodo_Anterior	INT
DECLARE @Json_Parametro										VARCHAR(8000)
DECLARE @Fecha_Desde										DATETIME
DECLARE @Fecha_Hasta										DATETIME
DECLARE @rta_CPJ_Productos_Cobros			TABLE (	Id_Centro_Costo		VARCHAR(10),
													Centro_Costo		VARCHAR(200),
													Imp_Prod_CIva		DECIMAL(15,2),
													Participacion		DECIMAL(12,2))

DECLARE @rta_CPJ_Pagos_CC					TABLE (	Id_Centro_Costo		VARCHAR(10),
													Centro_Costo		VARCHAR(200),
													Debe				DECIMAL(15,2),
													Haber				DECIMAL(15,2),
													Saldo				DECIMAL(15,2))

DECLARE @Id_Centro_Costo								CHAR(10)
DECLARE @Id_Unid_Negocio								CHAR(10)
DECLARE @Periodo										DATE
DECLARE @SA												DECIMAL(16,2)
DECLARE @Ingresos										DECIMAL(16,2)
DECLARE @Egresos										DECIMAL(16,2)
DECLARE @Saldo											DECIMAL(16,2)
DECLARE @Nota											VARCHAR(8000)
/*FIN Variables Locales*/

-------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@pModoDebug = 1)
BEGIN
	PRINT 'Ingreso a CPJ_Centro_Costos_Saldos_Generar'
END

-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Fecha_Desde = dbo.CF_FOMONTH(@pFecha)
SET @Fecha_Hasta = dbo.CF_EOMONTH(@pFecha)

-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Id_Centro_Costo					= @pId_Centro_Costo
SET @Id_Unid_Negocio					= @pId_Unid_Negocio
SET @Periodo							= @Fecha_Desde
SET @Nota								= 'Actualizado el ' + CONVERT(VARCHAR(20), GETDATE(), 120)

-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Ingresos = 0

SET @Json_Parametro =	'''{' +
						dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'SMALLINT') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Centro_Costo', @pId_Centro_Costo, 'VARCHAR(10)') + ',' +
						dbo.CF_Json_ParsearVariable('FechaDesde', @Fecha_Desde, 'DATETIME') + ',' +
						dbo.CF_Json_ParsearVariable('FechaHasta', @Fecha_Hasta, 'DATETIME') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Unid_Negocio', @pId_Unid_Negocio, 'VARCHAR(10)') + ',' +
						dbo.CF_Json_ParsearVariable('SoloResultado', 0, 'TINYINT') + ',' +
						dbo.CF_Json_ParsearVariable('Formato', 'CC', 'VARCHAR(3)') + ',' +
						dbo.CF_Json_ParsearVariable('Flag_Filtrar_CC', 1, 'TINYINT') +
						'}'''

IF(@pModoDebug = 1)
BEGIN
	PRINT 'CPJ_Productos_Cobros: ' + @Json_Parametro
END

INSERT INTO @rta_CPJ_Productos_Cobros
EXEC CPJ_Productos_Cobros @Json_Parametro

SET @Ingresos = ISNULL((SELECT SUM(Imp_Prod_CIva) FROM @rta_CPJ_Productos_Cobros), 0)

-----------------------------------------------------------------------------------------------------------------------------------------------------

SET @Egresos = 0

SET @Json_Parametro =	'''{' +
						dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'SMALLINT') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'SMALLINT') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Centro_Costo', @pId_Centro_Costo, 'VARCHAR(10)') + ',' +
						dbo.CF_Json_ParsearVariable('Fecha_Desde', @Fecha_Desde, 'DATETIME') + ',' +
						dbo.CF_Json_ParsearVariable('Fecha_Hasta', @Fecha_Hasta, 'DATETIME') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Alias_Cta_Cont', 0 , 'SMALLINT') + ',' +
						dbo.CF_Json_ParsearVariable('Id_Unid_Negocio', @pId_Unid_Negocio, 'VARCHAR(10)') + ',' +
						dbo.CF_Json_ParsearVariable('SoloResultado', 0, 'TINYINT') + ',' +
						dbo.CF_Json_ParsearVariable('Tipo_Reporte', 'CC', 'VARCHAR(3)') + ',' +
						dbo.CF_Json_ParsearVariable('Flag_Filtrar_CC', 1, 'TINYINT') +
						'}'''

IF(@pModoDebug = 1)
BEGIN
	PRINT 'CPJ_Pagos_CC: ' + @Json_Parametro
END

INSERT INTO @rta_CPJ_Pagos_CC
EXEC CPJ_Pagos_CC @Json_Parametro

SET @Egresos = ISNULL((SELECT SUM(Debe) FROM @rta_CPJ_Pagos_CC), 0)

-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Id_Centro_Costo_Saldo_Existente_Periodo_Anterior = ISNULL(	(SELECT MAX(Id_Centro_Costo_Saldo)
																FROM Centro_Costos_Saldos
																WHERE
																Id_Centro_Costo = @pId_Centro_Costo
																AND Id_Unid_Negocio = @pId_Unid_Negocio
																AND Periodo = DATEADD(MONTH, -1, @Fecha_Desde))
																, 0)

IF(@Id_Centro_Costo_Saldo_Existente_Periodo_Anterior <> 0)
BEGIN
	SELECT
	@SA		= ISNULL(Saldo, 0)
	FROM Centro_Costos_Saldos
	WHERE
	Id_Centro_Costo_Saldo = @Id_Centro_Costo_Saldo_Existente_Periodo_Anterior
END
ELSE
BEGIN
	SET @SA = 0
END

-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Saldo = @SA + @Ingresos - @Egresos

-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Id_Centro_Costo_Saldo_Existente = ISNULL(	(SELECT MAX(Id_Centro_Costo_Saldo)
												FROM Centro_Costos_Saldos
												WHERE
												Id_Centro_Costo = @pId_Centro_Costo
												AND Id_Unid_Negocio = @pId_Unid_Negocio
												AND Periodo = @Fecha_Desde)
												, 0)

IF(@Id_Centro_Costo_Saldo_Existente = 0)
BEGIN
	INSERT INTO Centro_Costos_Saldos
	(Id_Centro_Costo,
	Id_Unid_Negocio,
	Periodo,
	SA,
	Ingresos,
	Egresos,
	Saldo,
	Nota)
	VALUES
	(@Id_Centro_Costo,
	@Id_Unid_Negocio,
	@Periodo,
	@SA,
	@Ingresos,
	@Egresos,
	@Saldo,
	@Nota)

	
	SET @Id_Centro_Costo_Saldo_Existente = ISNULL(	(SELECT MAX(Id_Centro_Costo_Saldo)
												FROM Centro_Costos_Saldos
												WHERE
												Id_Centro_Costo = @pId_Centro_Costo
												AND Id_Unid_Negocio = @pId_Unid_Negocio
												AND Periodo = @Fecha_Desde)
												, 0)
END
ELSE
BEGIN
	UPDATE Centro_Costos_Saldos
	SET
	SA = @SA,
	Ingresos = @Ingresos,
	Egresos = @Egresos,
	Saldo = @Saldo,
	Nota = @Nota
	WHERE
	Id_Centro_Costo_Saldo = @Id_Centro_Costo_Saldo_Existente
END

-------------------------------------------------------------------------------------------------------------------------------------------------------

SELECT 
Id_Centro_Costo_Saldo,
Id_Centro_Costo,
Id_Unid_Negocio,
Periodo,
SA,
Ingresos,
Egresos,
Saldo,
Nota
FROM Centro_Costos_Saldos
WHERE
Id_Centro_Costo_Saldo = @Id_Centro_Costo_Saldo_Existente

-------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@pModoDebug = 1)
BEGIN
	PRINT 'FIN CPJ_Centro_Costos_Saldos_Generar'
END

/*
EXEC dbo.CPJ_Centro_Costos_Saldos_Generar   '{
												"Id_Usuario":"-1",
												"FlagUsarTrans":"0",
												"ModoDebug":"1",
												"Id_Centro_Costo":"7",
												"Id_Unid_Negocio":"",
												"Fecha":"20210401"
											  }'

EXEC dbo.CPJ_Centro_Costos_Saldos_Generar   '{
												"Id_Usuario":"-1",
												"FlagUsarTrans":"0",
												"ModoDebug":"1",
												"Id_Centro_Costo":"7",
												"Id_Unid_Negocio":"",
												"Fecha":"20210501"
											  }'
*/

